<?php
/**
 * @file field--fences-h2.tpl.php
 * Wrap each field value in the <h2> and <header> element.
 *
 * @see http://developers.whatwg.org/sections.html#the-h1,-h2,-h3,-h4,-h5,-and-h6-elements
 */
?>
<?php if ($element['#label_display'] == 'inline'): ?>
  <span class="field-label"<?php print $title_attributes; ?>>
    <?php print $label; ?>:
  </span>
<?php elseif ($element['#label_display'] == 'above'): ?>
  <h3 class="field-label"<?php print $title_attributes; ?>>
    <?php print $label; ?>
  </h3>
<?php endif; ?>

<?php foreach ($items as $delta => $item): ?>
  <header>
    <h2 class="<?php print $classes; ?>"<?php print $attributes; ?>>
      <?php print render($item); ?>
    </h2>
  </header>
<?php endforeach; ?>
